package it.eng.eremita.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.MultipartConfig;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;

import org.jboss.logging.Logger;

import it.eng.eremita.jpa.entity.DatiBinari;
import it.eng.eremita.jpa.entity.Documento;
import it.eng.eremita.jpa.manager.Accessor;
import it.eng.eremita.jpa.manager.EremitaManager;
import it.eng.eremita.util.ImageUtils;

@WebServlet(urlPatterns = {"/upload"})
@MultipartConfig
public class UploadServlet extends HttpServlet {
	
	long MAX_FILE_SIZE = 10000000;
	int LARGHEZZA_ANTEPRIMA = 200;
	int ALTEZZA_ANTEPRIMA = 200;
	final static String[] FORMATI_AMMESSI = {"GIF","JPG","PNG","BMP","PDF","DOC","ODT"};

    private final static Logger LOGGER = 
            Logger.getLogger(UploadServlet.class.getCanonicalName());
    
    
    public void doGet(HttpServletRequest request, HttpServletResponse response) {
    	response.setContentType("text/html;charset=UTF-8");
        //response.addHeader("Access-Control-Allow-Origin", "http://localhost:3000");
		//response.addHeader("Access-Control-Allow-Credentials", "true");
		response.setCharacterEncoding("UTF8");
		response.setHeader("Cache-Control", "no-cache");
    }
    
	public void doPost(HttpServletRequest request, HttpServletResponse response){
		try {
		processRequest(request, response);
		} catch (Exception e) {
			e.printStackTrace();
		}
		}
	
    protected void processRequest(HttpServletRequest request,
            HttpServletResponse response)
            throws ServletException, IOException {
    	
		EremitaManager eremitaManager;
		
		try {
 			Properties props=new Properties();		
	        Context ctx = new InitialContext(props);
	        
	        eremitaManager = (EremitaManager)ctx.lookup(Accessor.eremitaManagerJndi);
	        if (eremitaManager==null) {
	        	response.sendError(500);
				return;
	        }

		} catch (Exception e ) {
			e.printStackTrace();
			try {
				response.sendError(500);
			}catch (Exception e2) {
				e2.printStackTrace();
			}
			return;
		}
    	
    	
        response.setContentType("text/html;charset=UTF-8");
        //response.addHeader("Access-Control-Allow-Origin", "http://localhost:3000");
		//response.addHeader("Access-Control-Allow-Credentials", "true");
		response.setCharacterEncoding("UTF8");
		response.setHeader("Cache-Control", "no-cache");

        // Create path components to save the file
        String path = request.getParameter("uuid");
        String inElenco = request.getParameter("elenco");
        //final String name = request.getParameter("fileName");
        final Part filePart = request.getPart("file");
        String fname = getFileName(filePart);
        if (filePart.getSize()>MAX_FILE_SIZE) {
        	String s = "{\"risultato\":\"error\", \"descrizione\":\"File troppo grande\"  }";
        	response.getOutputStream().write(s.getBytes());
        	return;
        }
        
        if (path==null || path.equals("")) {
        	String s = "{\"risultato\":\"error\", \"descrizione\":\"UUID mancante\"  }";
        	response.getOutputStream().write(s.getBytes());
        	return;
        }
        path = path.trim();
        Documento d = null;
        DatiBinari db = null;
        try {
        	ArrayList<Object> al = new ArrayList<>();
        	al.add(path);
        	d = (Documento)eremitaManager.getSqlSingleResult(Documento.class, "select * from eremita_documento where uuid=?", al);
        	if (d==null) {
            	String s = "{\"risultato\":\"error\", \"descrizione\":\"Non esiste un documento con questo UUID\"  }";
            	response.getOutputStream().write(s.getBytes());
            	return;
        	}
        	if (d.getNomeFile()!=null && !"".equals(d.getNomeFile())) fname = d.getNomeFile();
        } catch (Exception e) {
        	String s = "{\"risultato\":\"error\", \"descrizione\":\"Errore nel caricamento dei metadati del documento\"  }";
        	response.getOutputStream().write(s.getBytes());
        	return;
        }
        
        db = (DatiBinari)eremitaManager.getById(DatiBinari.class, path);

        InputStream filecontent = filePart.getInputStream();
        byte[] dati = new byte[(int)filePart.getSize()]; 
        byte[] anteprima = null;

        try {
        	int offset = 0;
            int read = 0;
            while ((read = filecontent.read(dati, offset, (int)(filePart.getSize()-offset))) != -1 && (int)(filePart.getSize()-offset)>0) {
                offset+=read;
            }
            
            ArrayList<Object> li = new ArrayList<Object>();
            
            String magicNumber = ImageUtils.getMagicNumber(dati);
            if (magicNumber==null) {
            	response.sendError(200);
            	String s = "{\"risultato\":\"error\", \"descrizione\":\"Formato file non riconosciuto\"  }";
            	response.getOutputStream().write(s.getBytes());
            	return;           	
            }
            
            boolean ammesso = false;
            for (String formato : FORMATI_AMMESSI) {
            	if (magicNumber.equals(formato)) ammesso = true;
            }
            
            if (!ammesso) {
            	String s = "{\"risultato\":\"error\", \"descrizione\":\"Formato file riconosciuto ma non tra quelli ammessi\"  }";
            	response.getOutputStream().write(s.getBytes());
            	return;    
            }
            
            String nn = magicNumber;
            if (nn!=null && (nn.endsWith("JPG") || nn.endsWith("BMP") || nn.endsWith("PNG") || nn.endsWith("GIF")))
            	anteprima = ImageUtils.anteprima(dati, LARGHEZZA_ANTEPRIMA, ALTEZZA_ANTEPRIMA);
            	
            
            String s = "";
            if (db==null) {
            	li.add(path);
                li.add(dati);
                li.add(anteprima);
            	eremitaManager.updateSql("insert into main_dati_binari(id,dati,anteprima) values (?,?,?)", li);
                s = "{\"risultato\":\"success\", \"descrizione\":\"Record creato\" }";

            } else {
                li.add(dati);
                li.add(anteprima);
            	li.add(path);
            	eremitaManager.updateSql("update main_dati_binari set dati=?, anteprima=? where id=?", li);
                s = "{\"risultato\":\"success\", \"descrizione\":\"Record aggiornato\" }";
            }
            
            li.clear();
            li.add(fname);
            li.add(magicNumber);
            li.add(path);
            eremitaManager.updateSql("update eremita_documento set nome_file=?, formato=? where uuid=?", li);
            
            
        	response.getOutputStream().write(s.getBytes());

        } catch (Exception e) {
        	e.printStackTrace();
        	String s = "{\"risultato\":\"error\", \"descrizione\":\"Errore di upload\"  }";
        	response.getOutputStream().write(s.getBytes());
        }
        finally {
            if (filecontent != null) {
                filecontent.close();
            }

        }
    }
    
    
    private String getFileName(Part part) {
		for (String cd : part.getHeader("content-disposition").split(";")) {
			if (cd.trim().startsWith("filename")) {
				String s = cd.substring(cd.indexOf('=') + 1).trim()
						.replace("\"", "");
				if (s!=null && s.indexOf(':')>-1) {
					//path completo, ad esempio da quello schifo di Edge...
					s = s.substring(s.indexOf(':')+1);
					if (s.indexOf('\\')>-1) {
						s = s.substring(s.lastIndexOf('\\')+1);
					}
							
				}
				return s;
			}
		}
		return null;
	}

}
